--
-- NHPowerCommand
-- Specialization for NHPowerCommand gearbox
--
-- @author  JoXXer
-- @date  21/09/11
--

TurboWistle = {};

function TurboWistle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function TurboWistle:load(xmlFile)
	-- Turbowhistle
	local turboWhistle = getXMLString(xmlFile, "vehicle.turboWhistle#file");
	if turboWhistle ~= nil and turboWhistle ~= "" then
        turboWhistle = Utils.getFilename(turboWhistle, self.baseDirectory);
        self.turboWhistle = createSample("turboWhistle");
        self.playTurboWhistle = false;
		self.playedTurboWhistle = false;
        loadSample(self.turboWhistle, turboWhistle, false);
        self.turboWhistlePitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboWhistle#pitchOffset"), 1);
        self.turboWhistleVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboWhistle#volume"), 1);
    end;
	-- Turbowhistle interior
	local turboWhistleInterior = getXMLString(xmlFile, "vehicle.turboWhistleInterior#file");
	if turboWhistleInterior ~= nil and turboWhistleInterior ~= "" then
        turboWhistleInterior = Utils.getFilename(turboWhistleInterior, self.baseDirectory);
        self.turboWhistleInterior = createSample("turboWhistleInterior");
		self.playedTurboWhistleInterior = false;
        loadSample(self.turboWhistleInterior, turboWhistleInterior, false);
        self.turboWhistleInteriorPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboWhistleInterior#pitchOffset"), 1);
        self.turboWhistleInteriorVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turboWhistleInterior#volume"), 1);
    end;
end;

function TurboWistle:delete()
	if self.turboWhistle ~= nil then
		delete(self.turboWhistle);
		self.playTurboWhistle = false;
	end;
	if self.turboWhistleInterior ~= nil then
		delete(self.turboWhistleInterior);
		self.playTurboWhistleInterior = false;
	end;
end;

function TurboWistle:readStream(streamId, connection)
end;

function TurboWistle:writeStream(streamId, connection)
end;

function TurboWistle:readUpdateStream(streamId, timestamp, connection)

end;

function TurboWistle:writeUpdateStream(streamId, connection, dirtyMask)

end;

function TurboWistle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TurboWistle:keyEvent(unicode, sym, modifier, isDown)
end;

function TurboWistle:update(dt)
end;

function TurboWistle:updateTick(dt)
					if self.updatedAcceleration > 0.6 and acceleration == 0 and self:getIsActiveForSound() then
				if self.powerCommandThrottlePercentage > self.powerCommandMinRpm/self.motorMaxRpmLimit[3] then
					self.playTurboWhistle = false;
				else
					self.playTurboWhistle = true;
				end;
			elseif acceleration > 0 then
				self.playTurboWhistle = false;
			end;
					if self.turboWhistle ~= nil then
						local maxRpm  = self.motor.maxRpm[3];
						local rpmVolume = Utils.clamp(math.abs(roundPerSecond*60)/((maxRpm - self.motor.minRpm)), 0.0, 1.0);
						if self.playTurboWhistle and not self.playedTurboWhistle then
							playSample(self.turboWhistle, 1, self.turboWhistleVolume, 0);
							setSamplePitch(self.turboWhistle, self.turboWhistlePitchOffset);
							setSampleVolume(self.turboWhistle, rpmVolume);
							self.playedTurboWhistle = true;
						elseif not self.playTurboWhistle then
							stopSample(self.turboWhistle);
							self.playedTurboWhistle = false;
						end;
				else
					if self.turboWhistleInterior ~= nil then
						local maxRpm  = self.motor.maxRpm[3];
						local rpmVolume = Utils.clamp(math.abs(roundPerSecond*60)/((maxRpm - self.motor.minRpm)), 0.0, 1.0);
						if self.playTurboWhistle and not self.playedTurboWhistleInterior then
							playSample(self.turboWhistleInterior, 1, self.turboWhistleVolumeInterior, 0);
							setSamplePitch(self.turboWhistleInterior, self.turboWhistleInteriorPitchOffset);
							setSampleVolume(self.turboWhistleInterior, rpmVolume);
							self.playedTurboWhistleInterior = true;
						elseif not self.playTurboWhistle then
							stopSample(self.turboWhistleInterior);
							self.playedTurboWhistleInterior = false;
		end;
	end;
end;

function TurboWistle:draw()
end;

function TurboWistle:onLeave()
end;

function TurboWistle:stopMotor()
end;

function TurboWistle:stopSounds()
end;

function TurboWistle:startMotor()
end;

function TurboWistle:onEnter()
	end;
end;